
# Vol 1 Frame‑Coupling Constant κ

**Volume 1 of the Absolute Relativity Theory – Version 1**

This repository computes the discrete frame‑coupling constant

\[
  \kappa \;=\;\frac{\tau_{\rm nerve}}{t_{\rm collapse}}
\]

using the toy‑model example values given in Volume 1.

---

## 📜 Overview

- **Purpose**  
  Fix the strength of the frame‑coupling operator \(\Phi\). All claims of discrete Lorentz covariance rest on a real, measured \(\kappa\).

- **Inputs**  
  - Neural‑tick period \(\tau_{\rm nerve}\) (e.g. 20 ms)  
  - Collapse time \(t_{\rm collapse}\) (e.g. 0.9 ms)

- **Output**  
  A single numeric value of \(\kappa\), written to `results/kappa.txt`.

---

## 🛠️ Installation & Usage

1. **Clone the repo**  
   ```bash
   git clone https://github.com/Kent-Nimmo/vol1-frame-coupling.git
   cd vol1-frame-coupling
````

2. **(Optional) Create a virtual environment**

   ```bash
   python3 -m venv .venv
   source .venv/bin/activate   # macOS/Linux
   .venv\Scripts\activate      # Windows
   ```

3. **Install dependencies**

   ```bash
   pip install -r requirements.txt
   ```

4. **Run the script**

   ```bash
   python compute_kappa.py
   ```

   This will generate `results/kappa.txt` containing the numeric value of $\kappa$.

---

## ⚙️ Repo Structure

```
vol1-frame-coupling/
├── README.md
├── LICENSE            # MIT License
├── requirements.txt   # (can be empty or list any deps)
├── compute_kappa.py   # main script
├── .gitignore
└── results/
```

---

## License

This project is licensed under the MIT License.
See the [LICENSE](LICENSE) file for details.

```
